/*
 * Decompiled with CFR 0.152.
 */
package evercookie;

import evercookie.EvercookieBackend;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EvercookieJnlpBackend
implements EvercookieBackend {
    private PersistenceService persistenceService = null;
    private boolean isAvailable = true;
    private URL codebaseUrl;

    public EvercookieJnlpBackend() {
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            this.codebaseUrl = basicService.getCodeBase();
            this.persistenceService = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
        }
        catch (UnavailableServiceException e) {
            this.isAvailable = false;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Map<String, String> values) {
        try {
            FileContents file = this.persistenceService.get(this.codebaseUrl);
            ObjectOutputStream os = new ObjectOutputStream(file.getOutputStream(true));
            try {
                os.writeObject(values);
                os.flush();
            }
            finally {
                os.close();
            }
        }
        catch (FileNotFoundException e) {
            this.initialize();
            this.save(values);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Map<String, String> data) {
        try {
            FileContents file = this.persistenceService.get(this.codebaseUrl);
            ObjectInputStream is = new ObjectInputStream(file.getInputStream());
            try {
                Hashtable crap = (Hashtable)is.readObject();
                data.putAll(crap);
            }
            finally {
                is.close();
            }
        }
        catch (FileNotFoundException e) {
            this.initialize();
            this.save(data);
        }
        catch (ClassNotFoundException e) {
            this.save(data);
        }
        catch (EOFException e) {
            this.save(data);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cleanup() {
        try {
            this.persistenceService.delete(this.codebaseUrl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initialize() {
        try {
            long size = this.persistenceService.create(this.codebaseUrl, 16000L);
            System.out.println("Cache initialized at " + this.codebaseUrl + " with size " + size);
        }
        catch (Throwable e) {
            System.err.println("Unable to initialize cache.");
        }
    }
}

